class PBStuff
  #Standardized lists of moves or abilities which are sometimes called
  ABILITYBLACKLIST = [PBAbilities::MULTITYPE,PBAbilities::COMATOSE,PBAbilities::DISGUISE,
   PBAbilities::SCHOOLING,PBAbilities::RKSSYSTEM,PBAbilities::IMPOSTER,PBAbilities::SHIELDSDOWN,
   PBAbilities::POWEROFALCHEMY,PBAbilities::RECEIVER,PBAbilities::TRACE,PBAbilities::FORECAST,
   PBAbilities::FLOWERGIFT,PBAbilities::ILLUSION,PBAbilities::WONDERGUARD,PBAbilities::ZENMODE,
   PBAbilities::STANCECHANGE,PBAbilities::POWERCONSTRUCT,PBAbilities::ICEFACE,PBAbilities::RESUSCITATION]
  FIXEDABILITIES = [PBAbilities::MULTITYPE,PBAbilities::ZENMODE,PBAbilities::STANCECHANGE,
   PBAbilities::SCHOOLING,PBAbilities::COMATOSE,PBAbilities::SHIELDSDOWN,PBAbilities::DISGUISE,
   PBAbilities::RKSSYSTEM,PBAbilities::POWERCONSTRUCT,PBAbilities::ICEFACE,PBAbilities::GULPMISSILE,PBAbilities::RESUSCITATION,
   PBAbilities::SHIFT,PBAbilities::TEMPORALSHIFT,PBAbilities::EXECUTION,PBAbilities::ACCUMULATION,PBAbilities::WORLDOFNIGHTMARES]
   #Blacklisted abilities USUALLY can't be copied.
   #Fixed abilities USUALLY can't be changed.
  ANTIINTIMIDATEABILITIES = [PBAbilities::CONTRARY,PBAbilities::COMPETITIVE,PBAbilities::DEFIANT,
                             PBAbilities::RATTLED,PBAbilities::OWNTEMPO,PBAbilities::OBLIVIOUS,
                             PBAbilities::SCRAPPY]
  #List of Abilities that either prevent or co-opt Intimidate
  TRACEABILITIES = [PBAbilities::PROTEAN,PBAbilities::CONTRARY,PBAbilities::INTIMIDATE,
                          PBAbilities::WONDERGUARD,PBAbilities::MAGICGUARD,PBAbilities::UNAWARE,
                          PBAbilities::CHLOROPHYLL,PBAbilities::SWIFTSWIM,PBAbilities::SLUSHRUSH,
                          PBAbilities::SANDRUSH,PBAbilities::TELEPATHY,PBAbilities::SURGESURFER,
                          PBAbilities::SOLARPOWER,PBAbilities::DRYSKIN,PBAbilities::DOWNLOAD,
                          PBAbilities::LEVITATE,PBAbilities::LIGHTNINGROD,PBAbilities::MOTORDRIVE,
                          PBAbilities::VOLTABSORB,PBAbilities::FLASHFIRE,PBAbilities::MAGMAARMOR,
                          PBAbilities::ADAPTABILITY,PBAbilities::DEFIANT,PBAbilities::COMPETITIVE,
                          PBAbilities::PRANKSTER,PBAbilities::SPEEDBOOST,PBAbilities::MULTISCALE,
                          PBAbilities::SHADOWSHIELD,PBAbilities::SAPSIPPER,PBAbilities::FURCOAT,
                          PBAbilities::FLUFFY,PBAbilities::MAGICBOUNCE,PBAbilities::REGENERATOR,
                          PBAbilities::DAZZLING,PBAbilities::QUEENLYMAJESTY,PBAbilities::SOUNDPROOF,
                          PBAbilities::TECHNICIAN,PBAbilities::SPEEDBOOST,PBAbilities::STEAMENGINE,
                          PBAbilities::ICESCALES,PBAbilities::BEASTBOOST,PBAbilities::SHEDSKIN,
                          PBAbilities::CLEARBODY,PBAbilities::WHITESMOKE,PBAbilities::MOODY,
                          PBAbilities::THICKFAT,PBAbilities::STORMDRAIN,PBAbilities::SIMPLE,
                          PBAbilities::SOLARIDOL,PBAbilities::LUNARIDOL,
                          PBAbilities::PUREPOWER,PBAbilities::MARVELSCALE,PBAbilities::STURDY,
                          PBAbilities::MEGALAUNCHER,PBAbilities::LIBERO,PBAbilities::SHEERFORCE] 
  NEGATIVEABILITIES = [PBAbilities::TRUANT,PBAbilities::DEFEATIST,PBAbilities::SLOWSTART,
                       PBAbilities::KLUTZ,PBAbilities::STALL,PBAbilities::GORILLATACTICS,
                       PBAbilities::RIVALRY]
   #List of Abilities a Pokemon may want to Trace.                       
   #Standardized lists of moves with similar purposes/characteristics
   #(mostly just "stuff that gets called together")
  UNFREEZEMOVE = [PBMoves::FLAMEWHEEL,PBMoves::SACREDFIRE,PBMoves::FLAREBLITZ,
    PBMoves::FUSIONFLARE,PBMoves::SCALD,PBMoves::STEAMERUPTION,PBMoves::BURNUP]
  SWITCHOUTMOVE = [PBMoves::ROAR,PBMoves::WHIRLWIND,PBMoves::CIRCLETHROW,
    PBMoves::DRAGONTAIL,PBMoves::YAWN,PBMoves::PERISHSONG]
  SETUPMOVE = [PBMoves::SWORDSDANCE,PBMoves::DRAGONDANCE,PBMoves::CALMMIND,
    PBMoves::WORKUP,PBMoves::NASTYPLOT,PBMoves::TAILGLOW,PBMoves::BELLYDRUM,
    PBMoves::BULKUP,PBMoves::COIL,PBMoves::CURSE,PBMoves::GROWTH,
    PBMoves::HONECLAWS,PBMoves::QUIVERDANCE,PBMoves::SHELLSMASH]
  DEFSETUPMOVE = [PBMoves::IRONDEFENSE,PBMoves::AMNESIA,PBMoves::ACIDARMOR,
    PBMoves::BARRIER,PBMoves::DEFENDORDER,PBMoves::COSMICPOWER,PBMoves::MINIMIZE,
    PBMoves::HARDEN,PBMoves::WITHDRAW,PBMoves::DEFENSECURL,PBMoves::STOCKPILE]
  PROTECTMOVE = [PBMoves::PROTECT,PBMoves::DETECT,PBMoves::KINGSSHIELD,
    PBMoves::SPIKYSHIELD,PBMoves::BANEFULBUNKER,PBMoves::OBSTRUCT]
  PROTECTIGNORINGMOVE = [PBMoves::FEINT,PBMoves::HYPERSPACEHOLE,
    PBMoves::HYPERSPACEFURY,PBMoves::SHADOWFORCE,PBMoves::PHANTOMFORCE]
  SCREENBREAKERMOVE = [PBMoves::DEFOG,PBMoves::BRICKBREAK,PBMoves::PSYCHICFANGS]
  BITEMOVE = [PBMoves::BITE,PBMoves::CRUNCH,PBMoves::SUPERFANG,
              PBMoves::THUNDERFANG,PBMoves::ICEFANG,PBMoves::FIREFANG,
              PBMoves::HYPERFANG,PBMoves::POISONFANG,PBMoves::PSYCHICFANGS,
    PBMoves::JAWLOCK,PBMoves::FISHIOUSREND]
  HAZARDMOVE = [PBMoves::STEALTHROCK,PBMoves::TOXICSPIKES,PBMoves::SPIKES,PBMoves::STICKYWEB]
  POWDERMOVE = [PBMoves::SLEEPPOWDER,PBMoves::STUNSPORE,PBMoves::SPORE,PBMoves::POISONPOWDER,PBMoves::COTTONSPORE,PBMoves::POWDER,PBMoves::MAGICPOWDER,PBMoves::RAGEPOWDER]
  SCREENMOVE = [PBMoves::REFLECT,PBMoves::LIGHTSCREEN,PBMoves::AURORAVEIL,PBMoves::ARENITEWALL]
  CONTRARYBAITMOVE = [PBMoves::SUPERPOWER,PBMoves::OVERHEAT,PBMoves::DRACOMETEOR,
    PBMoves::LEAFSTORM,PBMoves::FLEURCANNON,PBMoves::PSYCHOBOOST,PBMoves::VCREATE]
  TWOTURNAIRMOVE = [PBMoves::BOUNCE,PBMoves::FLY,PBMoves::SKYDROP]
  TWOTURNMOVE = [PBMoves::BOUNCE,PBMoves::FLY,PBMoves::SKYDROP,PBMoves::DIVE,PBMoves::DIG,PBMoves::PHANTOMFORCE,PBMoves::SHADOWFORCE]
  PIVOTMOVE = [PBMoves::UTURN,PBMoves::VOLTSWITCH,PBMoves::PARTINGSHOT]
  DANCEMOVE = [PBMoves::QUIVERDANCE,PBMoves::DRAGONDANCE,PBMoves::FIERYDANCE,
    PBMoves::FEATHERDANCE,PBMoves::PETALDANCE,PBMoves::SWORDSDANCE,
    PBMoves::TEETERDANCE,PBMoves::LUNARDANCE,PBMoves::REVELATIONDANCE,PBMoves::AQUABATICS]
  BULLETMOVE = [PBMoves::ACIDSPRAY,PBMoves::AURASPHERE,PBMoves::BARRAGE,
    PBMoves::BULLETSEED,PBMoves::EGGBOMB,PBMoves::ELECTROBALL,PBMoves::ENERGYBALL,
    PBMoves::FOCUSBLAST,PBMoves::GYROBALL,PBMoves::ICEBALL,PBMoves::MAGNETBOMB,
    PBMoves::MISTBALL,PBMoves::MUDBOMB,PBMoves::OCTAZOOKA,PBMoves::ROCKWRECKER,
    PBMoves::SEARINGSHOT,PBMoves::SEEDBOMB,PBMoves::SHADOWBALL,PBMoves::SLUDGEBOMB,
    PBMoves::WEATHERBALL,PBMoves::ZAPCANNON,PBMoves::BEAKBLAST,PBMoves::PYROBALL,PBMoves::POLLENPUFF]
  PHASEMOVE = [PBMoves::ROAR,PBMoves::WHIRLWIND,PBMoves::CIRCLETHROW,
    PBMoves::DRAGONTAIL,PBMoves::YAWN]
  BOOMMOVE = [PBMoves::EXPLOSION,PBMoves::SELFDESTRUCT,PBMoves::MEMENTO, PBMoves::HEALINGWISH,PBMoves::LUNARDANCE]
  FLINCHMOVE= [PBMoves::AIRSLASH,PBMoves::ROCKSLIDE,PBMoves::WATERFALL,PBMoves::IRONHEAD,PBMoves::HEARTSTAMP,
    PBMoves::ICICLECRASH,PBMoves::EXTRASENSORY,PBMoves::DRAGONRUSH,PBMoves::DARKPULSE,PBMoves::AIRSLASH,
    PBMoves::STEAMROLLER,PBMoves::AIRSLASH,PBMoves::SKYATTACK,PBMoves::AIRSLASH,PBMoves::ZINGZAP,
    PBMoves::ICEFANG,PBMoves::FIREFANG,PBMoves::THUNDERFANG,PBMoves::STOMP,PBMoves::HEADBUTT,
    PBMoves::TWISTER,PBMoves::BITE]
  BURNMOVE = [PBMoves::WILLOWISP,PBMoves::SACREDFIRE,PBMoves::INFERNO]
  PARAMOVE = [PBMoves::THUNDERWAVE,PBMoves::STUNSPORE,PBMoves::GLARE,
    PBMoves::NUZZLE,PBMoves::ZAPCANNON]
  SLEEPMOVE = [PBMoves::SPORE,PBMoves::SLEEPPOWDER,PBMoves::HYPNOSIS,PBMoves::DARKVOID,
    PBMoves::GRASSWHISTLE,PBMoves::LOVELYKISS,PBMoves::SING]
  POISONMOVE = [PBMoves::TOXIC,PBMoves::POISONPOWDER,PBMoves::POISONGAS,PBMoves::TOXICTHREAD]
  CONFUMOVE = [PBMoves::CONFUSERAY,PBMoves::SUPERSONIC,PBMoves::FLATTER,PBMoves::SWAGGER,
    PBMoves::SWEETKISS,PBMoves::TEETERDANCE,PBMoves::CHATTER,PBMoves::DYNAMICPUNCH]

  HEALFUNCTIONS =  [0xD5,0xD6,0xD7,0xD8,0xD9,0xDD,0xDE,0xDF,0xE3,0xE4,0x114,0x139,0x158,0x162,0x169,0x16C,0x172]

  #massive arrays of stuff that no one wants to see
  TYPEBERRIES = [PBItems::CHILANBERRY,PBItems::OCCABERRY,PBItems::RINDOBERRY,PBItems::WACANBERRY,PBItems::HABANBERRY,PBItems::PASSHOBERRY,
  PBItems::CHARTIBERRY,PBItems::SHUCABERRY,PBItems::YACHEBERRY,PBItems::KASIBBERRY,PBItems::TANGABERRY,PBItems::COLBURBERRY,PBItems::BABIRIBERRY,
  PBItems::ROSELIBERRY,PBItems::CHOPLEBERRY,PBItems::KEBIABERRY,PBItems::COBABERRY,PBItems::PAYAPABERRY]
  SEEDS = [PBItems::TELLURICSEED,PBItems::MAGICALSEED,PBItems::SYNTHETICSEED,PBItems::ELEMENTALSEED]
  TELLURICFIELDS = [8,10,12,14,15,16,19,20,23,27,28]
  ELEMENTALFIELDS = [1,2,3,7,11,13,21,22,26,32,39,43]
  MAGICALFIELDS = [4,9,25,29,31,34,35,37,38,40]
  SYNTHETICFIELDS = [5,6,17,18,24,30,33,41]
  BERRYTYPES={
    PBTypes::FIRE =>[:OCCABERRY],
    PBTypes::WATER =>[:PASSHOBERRY],
    PBTypes::ELECTRIC =>[:WACANBERRY],
    PBTypes::PSYCHIC =>[:PAYAPABERRY],
    PBTypes::ICE =>[:YACHEBERRY],
    PBTypes::DRAGON =>[:HABANBERRY],
    PBTypes::FIGHTING =>[:CHOPLEBERRY],
    PBTypes::FAIRY =>[:ROSELIBERRY],
    PBTypes::STEEL =>[:BABIRIBERRY],
    PBTypes::GHOST =>[:KASIBBERRY],
    PBTypes::DARK =>[:COLBURBERRY],
    PBTypes::FLYING =>[:COBABERRY],
    PBTypes::ROCK =>[:CHARTIBERRY],
    PBTypes::GROUND =>[:SHUCABERRY],
    PBTypes::GRASS =>[:RINDOBERRY],
    PBTypes::BUG =>[:TANGABERRY],
    PBTypes::NORMAL =>[:CHILANBERRY],
    PBTypes::POISON =>[:KEBIABERRY]
  }
  NATURALGIFTDAMAGE={
    100 => [:WATMELBERRY,:DURINBERRY,:BELUEBERRY,:LIECHIBERRY,:GANLONBERRY,:SALACBERRY,
            :PETAYABERRY,:APICOTBERRY,:LANSATBERRY,:STARFBERRY,:ENIGMABERRY,:MICLEBERRY,
            :CUSTAPBERRY,:JABOCABERRY,:ROWAPBERRY],
     90 => [:BLUKBERRY,:NANABBERRY,:WEPEARBERRY,:PINAPBERRY,:POMEGBERRY,:KELPSYBERRY,
            :QUALOTBERRY,:HONDEWBERRY,:GREPABERRY,:TAMATOBERRY,:CORNNBERRY,:MAGOSTBERRY,
            :RABUTABERRY,:NOMELBERRY,:SPELONBERRY,:PAMTREBERRY],
     80 => [:CHERIBERRY,:CHESTOBERRY,:PECHABERRY,:RAWSTBERRY,:ASPEARBERRY,:LEPPABERRY,
            :ORANBERRY,:PERSIMBERRY,:LUMBERRY,:SITRUSBERRY,:FIGYBERRY,:WIKIBERRY,
            :MAGOBERRY,:AGUAVBERRY,:IAPAPABERRY,:RAZZBERRY,:OCCABERRY,:PASSHOBERRY,
            :WACANBERRY,:RINDOBERRY,:YACHEBERRY,:CHOPLEBERRY,:KEBIABERRY,:SHUCABERRY,
            :COBABERRY,:PAYAPABERRY,:TANGABERRY,:CHARTIBERRY,:KASIBBERRY,:HABANBERRY,
            :COLBURBERRY,:BABIRIBERRY,:CHILANBERRY]} 
  FLINGDAMAGE={
    300 => [:MEMEONADE],
    130 => [:IRONBALL],
    100 => [:ARMORFOSSIL,:CLAWFOSSIL,:COVERFOSSIL,:DOMEFOSSIL,:HARDSTONE,:HELIXFOSSIL,
            :OLDAMBER,:PLUMEFOSSIL,:RAREBONE,:ROOTFOSSIL,:SKULLFOSSIL],
     90 => [:DEEPSEATOOTH,:DRACOPLATE,:DREADPLATE,:EARTHPLATE,:FISTPLATE,:FLAMEPLATE,
            :GRIPCLAW,:ICICLEPLATE,:INSECTPLATE,:IRONPLATE,:MEADOWPLATE,:MINDPLATE,
            :SKYPLATE,:SPLASHPLATE,:SPOOKYPLATE,:STONEPLATE,:THICKCLUB,:TOXICPLATE,
            :ZAPPLATE],
     80 => [:DAWNSTONE,:DUSKSTONE,:ELECTIRIZER,:MAGMARIZER,:ODDKEYSTONE,:OVALSTONE,
            :PROTECTOR,:QUICKCLAW,:RAZORCLAW,:SHINYSTONE,:STICKYBARB,:ASSAULTVEST],
     70 => [:BURNDRIVE,:CHILLDRIVE,:DOUSEDRIVE,:DRAGONFANG,:POISONBARB,:POWERANKLET,
            :POWERBAND,:POWERBELT,:POWERBRACER,:POWERLENS,:POWERWEIGHT,:SHOCKDRIVE],
     60 => [:ADAMANTORB,:DAMPROCK,:HEATROCK,:LUSTROUSORB,:MACHOBRACE,:ROCKYHELMET,
            :STICK,:AMPLIFIELDROCK,:ADRENALINEORB],
     50 => [:DUBIOUSDISC,:SHARPBEAK],
     40 => [:EVIOLITE,:ICYROCK,:LUCKYPUNCH,:PROTECTIVEPADS],
     30 => [:ABILITYURGE,:ABSORBBULB,:AMULETCOIN,:ANTIDOTE,:AWAKENING,:BALMMUSHROOM,
            :BERRYJUICE,:BIGMUSHROOM,:BIGNUGGET,:BIGPEARL,:BINDINGBAND,:BLACKBELT,
            :BLACKFLUTE,:BLACKGLASSES,:BLACKSLUDGE,:BLUEFLUTE,:BLUESHARD,:BURNHEAL,
            :CALCIUM,:CARBOS,:CASTELIACONE,:CELLBATTERY,:CHARCOAL,:CLEANSETAG,
            :COMETSHARD,:DAMPMULCH,:DEEPSEASCALE,:DIREHIT,:DIREHIT2,:DIREHIT3,
            :DRAGONSCALE,:EJECTBUTTON,:ELIXIR,:ENERGYPOWDER,:ENERGYROOT,:ESCAPEROPE,
            :ETHER,:EVERSTONE,:EXPSHARE,:FIRESTONE,:FLAMEORB,:FLOATSTONE,:FLUFFYTAIL,
            :FRESHWATER,:FULLHEAL,:FULLRESTORE,:GOOEYMULCH,:GREENSHARD,:GROWTHMULCH,
            :GUARDSPEC,:HEALPOWDER,:HEARTSCALE,:HONEY,:HPUP,:HYPERPOTION,:ICEHEAL,
            :IRON,:ITEMDROP,:ITEMURGE,:KINGSROCK,:LAVACOOKIE,:LEAFSTONE,:LEMONADE,
            :LIFEORB,:LIGHTBALL,:LIGHTCLAY,:LUCKYEGG,:MAGNET,:MAXELIXIR,:MAXETHER,
            :MAXPOTION,:MAXREPEL,:MAXREVIVE,:METALCOAT,:METRONOME,:MIRACLESEED,
            :MOOMOOMILK,:MOONSTONE,:MYSTICWATER,:NEVERMELTICE,:NUGGET,:OLDGATEAU,
            :PARLYZHEAL,:PEARL,:PEARLSTRING,:POKEDOLL,:POKETOY,:POTION,:PPMAX,:PPUP,
            :PRISMSCALE,:PROTEIN,:RAGECANDYBAR,:RARECANDY,:RAZORFANG,:REDFLUTE,
            :REDSHARD,:RELICBAND,:RELICCOPPER,:RELICCROWN,:RELICGOLD,:RELICSILVER,
            :RELICSTATUE,:RELICVASE,:REPEL,:RESETURGE,:REVIVALHERB,:REVIVE,:SACREDASH,
            :SCOPELENS,:SHELLBELL,:SHOALSALT,:SHOALSHELL,:SMOKEBALL,:SODAPOP,:SOULDEW,
            :SPELLTAG,:STABLEMULCH,:STARDUST,:STARPIECE,:SUNSTONE,:SUPERPOTION,
            :SUPERREPEL,:SWEETHEART,:THUNDERSTONE,:TINYMUSHROOM,:TOXICORB,
            :TWISTEDSPOON,:UPGRADE,:WATERSTONE,:WHITEFLUTE,:XACCURACY,:XACCURACY2,
            :XACCURACY3,:XACCURACY6,:XATTACK,:XATTACK2,:XATTACK3,:XATTACK6,:XDEFEND,
            :XDEFEND2,:XDEFEND3,:XDEFEND6,:XSPDEF,:XSPDEF2,:XSPDEF3,:XSPDEF6,:XSPECIAL,
            :XSPECIAL2,:XSPECIAL3,:XSPECIAL6,:XSPEED,:XSPEED2,:XSPEED3,:XSPEED6,
            :YELLOWFLUTE,:YELLOWSHARD,:ZINC,:BIGMALASADA,:ICESTONE],
     20 => [:CLEVERWING,:GENIUSWING,:HEALTHWING,:MUSCLEWING,:PRETTYWING,
            :RESISTWING,:SWIFTWING],
     10 => [:AIRBALLOON,:BIGROOT,:BLUESCARF,:BRIGHTPOWDER,:CHOICEBAND,:CHOICESCARF,
            :CHOICESPECS,:DESTINYKNOT,:EXPERTBELT,:FOCUSBAND,:FOCUSSASH,:FULLINCENSE,
            :GREENSCARF,:LAGGINGTAIL,:LAXINCENSE,:LEFTOVERS,:LUCKINCENSE,:MENTALHERB,
            :METALPOWDER,:MUSCLEBAND,:ODDINCENSE,:PINKSCARF,:POWERHERB,:PUREINCENSE,
            :QUICKPOWDER,:REAPERCLOTH,:REDCARD,:REDSCARF,:RINGTARGET,:ROCKINCENSE,
            :ROSEINCENSE,:SEAINCENSE,:SHEDSHELL,:SILKSCARF,:SILVERPOWDER,:SMOOTHROCK,
            :SOFTSAND,:SOOTHEBELL,:WAVEINCENSE,:WHITEHERB,:WIDELENS,:WISEGLASSES,
            :YELLOWSCARF,:ZOOMLENS,:BLUEMIC,:VANILLAIC,:STRAWBIC,:CHOCOLATEIC]}
end

class PBMonRoles
  SWEEPER         = 0
  PHYSICALWALL    = 1
  SPECIALWALL     = 2
  LEAD            = 3
  CLERIC          = 4
  PHAZER          = 5
  SCREENER        = 6
  REVENGEKILLER   = 7
  PIVOT           = 8
  SPINNER         = 9
  TANK            = 10
  BATONPASSER     = 11
  STALLBREAKER    = 12
  STATUSABSORBER  = 13
  TRAPPER         = 14
  WEATHERSETTER   = 15
  FIELDSETTER     = 16
  ACE             = 17
  SECOND          = 18
  STALLMON        = 19
  HAZARDLEAD      = 20
end

class PBMoves
BREAKNECKBLITZ                 =10001
ALLOUTPUMMELING                =10002
SUPERSONICSKYSTRIKE            =10003
ACIDDOWNPOUR                   =10004
TECTONICRAGE                   =10005
CONTINENTALCRUSH               =10006
SAVAGESPINOUT                  =10007
NEVERENDINGNIGHTMARE           =10008
CORKSCREWCRASH                 =10009
INFERNOOVERDRIVE               =10010
HYDROVORTEX                    =10011
BLOOMDOOM                      =10012
GIGAVOLTHAVOC                  =10013
SHATTEREDPSYCHE                =10014
SUBZEROSLAMMER                 =10015
DEVASTATINGDRAKE               =10016
BLACKHOLEECLIPSE               =10017
TWINKLETACKLE                  =10018
STOKEDSPARKSURFER              =10019
SINISTERARROWRAID              =10020
MALICIOUSMOONSAULT             =10021
OCEANICOPERETTA                =10022
EXTREMEEVOBOOST                =10023
CATASTROPIKA                   =10024
PULVERIZINGPANCAKE             =10025
GENESISSUPERNOVA               =10026
GUARDIANOFALOLA                =10027
SOULSTEALING7STARSTRIKE        =10028
CLANGOROUSSOULBLAZE            =10029
SPLINTEREDSTORMSHARDS          =10030
LETSSNUGGLEFOREVER             =10031
SEARINGSUNRAZESMASH            =10032
MENACINGMOONRAZEMAELSTROM      =10033
LIGHTTHATBURNSTHESKY           =10034
THEOLIADASH                    =10035
THEOLIASHIELD                  =10036
THEOLIAILLUSION                =10037
THEOLIASTRIKE                  =10038

end